/* Ändert die festgepinnte Hauptressource eines gegebenen AGs auf die gegebene neue Ressource.

  Wird die Option @_all_ag_withthis_resource@ gesetzt, werden alle AGe mit der gleichen Ausgangsresource, wie der gegebene AG
  auf die neue Hauptressource festgepinnt.
*/
SELECT tsystem.function__drop_by_regex( 'ab2__resource__move', _commit => true ); --Alter Funktionsname
--
SELECT tsystem.function__drop_by_regex( 'ab2_wkstplan__resource_id_main_fix__move__set', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2_wkstplan__resource_id_main_fix__move__set(
    IN _a2_id                     integer,
    IN _to_resource_id            integer,
    IN _all_ag_withthis_resource  bool = true, -- ACHTUNG. er kan die Signatur zu oben Numeric nicht unterscheiden, daher hier ein anderer Name
    IN _loglevel                  int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
    )
    RETURNS bool AS $$
    DECLARE
        a2ids integer[];
        r record;

    BEGIN
        -- Muss in Oberfläche mit Selection-F2!

        -- Alle, oder nur der angegebene AG.
        -- alle a2_id's in array sammeln: alle Arbeitsgänge der angegebenen ABK (über a2_id), welche die gleiche Kostenstelle haben
        IF _all_ag_withthis_resource THEN
            FOR r IN SELECT ab2_allAG.a2_id
                      FROM ab2
                      JOIN ab2_wkstplan  ab2w     ON ab2w.a2w_a2_id     = ab2.a2_id AND NOT a2w_marked = -1 -- SplitAGs;
                      JOIN ab2 ab2_allAG          ON ab2_allAG.a2_ab_ix = ab2.a2_ab_ix
                      JOIN ab2_wkstplan  ab2w_all ON ab2w_all.a2w_a2_id = ab2_allAG.a2_id
                      WHERE ab2.a2_id = _a2_id
                        AND coalesce(ab2w.a2w_resource_id_main_fix::varchar, ab2.a2_ks) = coalesce(ab2w_all.a2w_resource_id_main_fix::varchar, ab2_allAG.a2_ks)
                        AND ab2w_all.a2w_resource_id_main_fix IS DISTINCT FROM _to_resource_id
                  ORDER BY ab2_allAG.a2_n
            LOOP
              a2ids := array_append(a2ids, r.a2_id);
            END LOOP;
        ELSE
            a2ids := array_append(a2ids, _a2_id);
        END IF;


        -- VERKETTUNG (ab2_group)
        -- Alle verschieben, die mit mir verkettet sind und auf der gleichen Resource liegen
        FOR r IN  SELECT a2_id_chain
                         /*-- DEBUG
                         , a2_id_src, ab2_from.a2_ab_ix, ab2_from.a2_n, ab2_from.a2_id
                         , a2_id_chain, ab2_to.a2_ab_ix, ab2_to.a2_n, ab2_to.a2_id
                         , a2w_to.a2w_resource_id_main_fix
                         , a2w_from.a2w_resource_id_main_terminated, a2w_to.a2w_resource_id_main_terminated
                         , ab2_from.a2_ks, ab2_to.a2_ks 
                         -- */
                    FROM tabk.ab2_groups__recursive__by__a2_id__get(_a2_id)
                  LEFT JOIN ab2_wkstplan a2w_from ON a2w_from.a2w_a2_id  = a2_id_src
                  LEFT JOIN ab2 ab2_from          ON ab2_from.a2_id      = a2_id_src
                  LEFT JOIN ab2_wkstplan a2w_to   ON a2w_to.a2w_a2_id    = a2_id_chain
                  LEFT JOIN ab2 ab2_to            ON ab2_to.a2_id        = a2_id_chain
                  WHERE a2w_to.a2w_resource_id_main_fix IS DISTINCT FROM _to_resource_id
                    AND (    (a2w_from.a2w_resource_id_main_terminated IS null /*Erstes Element hat nie Vorgänger*/ OR a2w_from.a2w_resource_id_main_terminated = a2w_to.a2w_resource_id_main_terminated)
                        OR (    coalesce(a2w_from.a2w_resource_id_main_terminated, a2w_to.a2w_resource_id_main_terminated) IS null
                            AND ab2_from.a2_ks = ab2_to.a2_ks
                            )
                        )
        LOOP
            a2ids := array_append(a2ids, r.a2_id_chain);
        END LOOP;

        --
        RAISE NOTICE 'ab2_wkstplan__resource_id_main_fix__move__set:% -> ab2_groups_follower: %', _a2_id, a2ids;

        -- array durchgehen - und alle a2_id verschieben auf andere resource.
        --PERFORM scheduling.ab2__resource_requirement_options__replace( ab2.a2_id, _to_resource_id, _loglevel => _loglevel )
        --   FROM ab2
        UPDATE ab2_wkstplan
            SET a2w_resource_id_main_fix = _to_resource_id
          WHERE a2w_a2_id = any(a2ids)
            AND a2w_resource_id_main_fix IS DISTINCT FROM _to_resource_id; -- da Gruppen immer follower setzen aber zB resource_timeline__abk_ab2__termination__grouped einen Array inkl. Follower reingibt. (FROM unnest(_r.ab2s_id__complete))
        --
        PERFORM scheduling.ab2__resource_requirement_options__add_option(
                    _ab2_id         => a2_id
                  , _resource_id    => _to_resource_id
                  , _load           => ifthen( scheduling.resource__is_auswaerts( _to_resource_id ), 0, 1 )
                  , _loglevel       => _loglevel
                )
            FROM ab2
          WHERE a2_id = any(a2ids);
        --
        RETURN true;
    END $$ LANGUAGE plpgsql;